/**
 * @file Drv_SysClock.c
 * @author 吳星萍 iris@e-besthealth.com
 * @brief  系統頻率
 * @version 0.1
 * @date 2020-02-21
 *
 * @copyright BEST HEALTH ELECTRONIC INC (c) 2019
 *
 * Compiler Ver. : V3.57
 * IDE3000  Ver. : V8.03
 * MCU/CFG  Ver. : BH67F5362/1.1
 */

#include "Project_Global.h"
#include "BH67F5362.h"
#include "Drv_SysClock.h"
#include "Drv_GPIO.h"

/**
 * @brief 配置系統頻率
 * @detail 可選系統頻率 低速=LIRC/LXT  高速=HIRC_8M/HIRC_12M/HIRC_16M
 *
 * @note 注解
 * @attention 部分IC LXT功能 需要在 LXT2 Pin 加上拉10M到 VDD，詳細參考規格書 LXT 描述
 * @warning 部分IC 在線Debug時,LXT無法使用，可先切換為LIRC，debugOK後在切換為LXT
 * @exception 部分IC 若電路 HXT 晶振會造成程序在此死循環
 */
void Drv_SysClockInit()
{
    // *********系統時鐘設定********//
    #ifdef _HXT_
        SET_PB6_OSC1();
        SET_PB7_OSC2();
        _hxtm = 0;
        _hxten = 1;
     	_fhs   = 1;
        _fhiden = 1;
        while (!_hxtf)
        {
            GCC_CLRWDT();	
        }   // Wait HXT Oscillator Stable 
    #endif // _HXT_
    #ifdef _HIRC_8M_
     	_fhs   = 0;
        _hircc = 0x01;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_8M_
    #ifdef _HIRC_12M_
        _fhs   = 0;
        _hircc = 0x05;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_12M_
    #ifdef _HIRC_16M_
        _fhs   = 0;
        _hircc = 0x09;
        while (!_hircf);    // Wait HIRC Oscillator Stable
    #endif // _HIRC_16M_
    #ifdef _LXT_
        _lxten = 1;
        _fss   = 1;
		_fsiden = 1;		// Enter Halt LXT Is Enable
        SET_PF5_XT1();
        SET_PF4_XT2();
        while (!_lxtf)      //啟動時間Tsst=1024 Tlxt
        {
        	GCC_CLRWDT();
        }     // Wait LXT Oscillator Stable
    #endif // _LXT_
    #ifdef _LIRC_
        _fss   = 0;
        _lxten = 0;
		_fsiden = 1;		// Enter Halt LIRC Is Enable
    #endif // _LIRC_
}